---
title: Require a specific cookie · Cloudflare Web Application Firewall (WAF) docs
description: To secure a sensitive area such as a development area, you can
  share a cookie with trusted individuals and then filter requests so that only
  users with that cookie can access your site.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/require-specific-cookie/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/require-specific-cookie/index.md
---

To secure a sensitive area such as a development area, you can share a cookie with trusted individuals and then filter requests so that only users with that cookie can access your site.

Use the [`http.cookie`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.cookie/) field to target requests based on the presence of a specific cookie.

This example comprises two custom rules:

* The first rule targets requests to `dev.www.example.com` that have a specific cookie key, `devaccess`. As long as the value of the cookie key contains one of three authorized users — `james`, `matt`, or `michael` — the expression matches and the request is allowed, skipping all other custom rules.
* The second rule blocks all access to `dev.www.example.com`.

Since custom rules are evaluated in order, Cloudflare grants access to requests that satisfy rule 1 and blocks all other requests to `dev.www.example.com`:

**Rule 1:**

* **Expression**: `(http.cookie contains "devaccess=james" or http.cookie contains "devaccess=matt" or http.cookie contains "devaccess=michael") and http.host eq "dev.www.example.com"`
* **Action**: *Skip:*
  * *All remaining custom rules*

**Rule 2:**

* **Expression**: `(http.host eq "dev.www.example.com")`
* **Action**: *Block*
