---
title: Available skip options · Cloudflare Web Application Firewall (WAF) docs
description: "The available skip options in custom rules are the following:"
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/skip/options/
  md: https://developers.cloudflare.com/waf/custom-rules/skip/options/index.md
---

The available skip options in custom rules are the following:

* **Skip the remaining custom rules (current ruleset)**

  * Dashboard option: **All remaining custom rules**.
  * API action parameter: `ruleset`.
  * Skips the remaining rules in the current ruleset.

* **Skip phases**

  * Dashboard options: **All rate limiting rules**, **All Super Bot Fight Mode rules**, and **All managed rules**.

  * API action parameter: `phases`.

  * Skips the execution of one or more phases. Based on the phases you can skip, this option effectively allows you to skip [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), [Super Bot Fight Mode rules](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/), and/or [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/).

  * The phases you can skip are the following:

    * `http_ratelimit`
    * `http_request_sbfm`
    * `http_request_firewall_managed`

  * Refer to [Phases](https://developers.cloudflare.com/ruleset-engine/about/phases/) for more information.

* **Skip products**

  * API action parameter: `products`.

  * Skips specific security products that are not based on the Ruleset Engine. The products you can skip are the following:

  * | Product name in the dashboard | API value |
    | - | - |
    | [Zone Lockdown](https://developers.cloudflare.com/waf/tools/zone-lockdown/) | `zoneLockdown` |
    | [User Agent Blocking](https://developers.cloudflare.com/waf/tools/user-agent-blocking/) | `uaBlock` |
    | [Browser Integrity Check](https://developers.cloudflare.com/waf/tools/browser-integrity-check/) | `bic` |
    | [Hotlink Protection](https://developers.cloudflare.com/waf/tools/scrape-shield/hotlink-protection/) | `hot` |
    | [Security Level](https://developers.cloudflare.com/waf/tools/security-level/) | `securityLevel` |
    | [Rate limiting rules (Previous version)](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/) | `rateLimit` |
    | [Managed rules (Previous version)](https://developers.cloudflare.com/waf/reference/legacy/old-waf-managed-rules/) | `waf` |

  * The API values are case-sensitive.

  * Currently, you cannot skip [Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/bot-fight-mode/), only Super Bot Fight Mode (refer to Skip phases above).

Note

If you configure a skip rule at the account level it will only affect other rules/phases configured at the account level, not at the zone level. To skip rules/phases at the zone level you must configure a skip rule at the zone level.

## Logging

* **Log requests matching the skip rule**

  * Dashboard option: **Log matching requests**.
  * API action parameter: `logging` > `enabled` (boolean, optional).
  * When disabled, Cloudflare will not log any requests matching the current skip rule, and these requests will not appear in [Security Events](https://developers.cloudflare.com/waf/analytics/security-events/).
  * If you do not specify this option in the API, the default value is `true` for custom rules with the skip action (logs requests matching the skip rule).
