---
title: Pseudo IPv4 · Cloudflare Network settings docs
description: Cloudflare customers can use Pseudo IPv4 if their origin web server
  only understands IPv4 formatted IP addresses (meaning it would not support
  Cloudflare's default IPv6 compatibility).
lastUpdated: 2024-12-16T22:33:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network/pseudo-ipv4/
  md: https://developers.cloudflare.com/network/pseudo-ipv4/index.md
---

Cloudflare customers can use **Pseudo IPv4** if their origin web server only understands IPv4 formatted IP addresses (meaning it would not support Cloudflare's default [IPv6 compatibility](https://developers.cloudflare.com/network/ipv6-compatibility/)).

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |

## Background

Some older origin server analytics and fraud detection software expect IP addresses in an IPv4 format and do not support IPv6 addresses.

**Pseudo IPv4** uses the [Class E IPv4 address space](https://tools.ietf.org/html/rfc1112#section-4) to provide as many unique IPv4 addresses corresponding to IPv6 addresses as possible.

* Example Class E IPv4 address: `240.16.0.1`
* Example IPv6 address: `2400:cb00:f00d:dead:beef:1111:2222:3333`

Note

Class E IPv4 addresses are designated as experimental and are not used for production Internet traffic.

## Configure Pseudo IPv4

Cloudflare offers three options for configuring **Pseudo IPv4**:

* **Off**: Default value.

* **Add Header**: Cloudflare automatically adds the `Cf-Pseudo-IPv4` header with a Class E IPv4 address hashed from the original IPv6 address.

* **Overwrite Headers**: 

  If **Pseudo IPv4** is set to `Overwrite Headers` - Cloudflare overwrites the existing `Cf-Connecting-IP` and `X-Forwarded-For` headers with a pseudo IPv4 address while preserving the real IPv6 address in `CF-Connecting-IPv6` header.

Note

When using *Overwrite Headers*, no software changes are necessary in your origin web server.

To configure **Pseudo IPv4**:

* Dashboard

  To change the **Pseudo IPv4** setting in the dashboard:

  1. Log in to your [Cloudflare account](https://dash.cloudflare.com) and go to a specific domain.
  2. Go to **Network**.
  3. For **Pseudo IPv4**, choose your desired setting.

* API

  To change **Pseudo IPv4** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `pseudo_ipv4` as the setting name in the URI path, and the `value` parameter set to your desired value: `"off"`, `"add_header"`, or `"overwrite_header"`.
